#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include scripts\utility;
#include maps\mp\gametypes\common_sd_sr;
#include maps\mp\gametypes\sd;
#include maps\mp\gametypes\_gamelogic;

init(){
    precachemodel( "equip_iw4_throwingknife_npc" );
    replacefunc(maps\mp\gametypes\_weapons::throwingknifeusage, ::autoPickupThrowingKnife);
    replacefunc(maps\mp\gametypes\_menus::menugiveclass, ::mef_menugiveclass);

    replacefunc(maps\mp\gametypes\_gamelogic::matchstarttimer, ::gf_matchstarttimer);

    replacefunc(maps\mp\gametypes\_gamelogic::callback_startgametype, ::gf_callback_startgametype);

    level thread user_scripts\mp_patches\mef\game::init();
}


gf_matchstarttimer( var_0 )
{
    var_0 = 3;
    if(getDvar("gf_currentMap2") != getDvar("mapname")){
		setDvar("gf_currentMap2", getDvar("mapname"));
        var_0 = 15;
	}
    self notify( "matchStartTimer" );
    self endon( "matchStartTimer" );
    level notify( "match_start_timer_beginning" );
    var_1 = int( var_0 );
    childthread matchstartvisionfadeout( var_1 );

    if ( var_1 >= 2 )
        matchstarttimer_internal( var_1 );
    else
    {
        if ( level.currentgen )
            setomnvar( "ui_cg_world_blur_fade_out", 1 );

        if ( !maps\mp\_utility::privatematch() && !maps\mp\_utility::is_true( level.ishorde ) && !maps\mp\_utility::is_true( level.iszombiegame ) )
        {
            if ( level.xpscale > 1 )
            {
                foreach ( var_3 in level.players )
                    var_3 thread maps\mp\gametypes\_hud_message::splashnotify( "double_xp" );
            }
            else if ( level.xpscalewithparty > 1 )
            {
                foreach ( var_3 in level.players )
                {
                    if ( maps\mp\_utility::is_true( var_3.inpartywithotherplayers ) )
                        var_3 thread maps\mp\gametypes\_hud_message::splashnotify( "double_xp" );
                }
            }
        }
    }
}

gf_callback_startgametype()
{
    maps\mp\_load::main();
    maps\mp\_utility::levelflaginit( "round_over", 0 );
    maps\mp\_utility::levelflaginit( "game_over", 0 );
    maps\mp\_utility::levelflaginit( "block_notifies", 0 );
    level.prematchperiod = 0;
    level.prematchperiodend = 0;
    level.postgamenotifies = 0;
    level.intermission = 0;
    setdvar( "bg_compassShowEnemies", getdvar( "scr_game_forceuav" ) );

    if ( !isdefined( game["gamestarted"] ) )
    {
        game["clientid"] = 0;
        var_0 = getmapcustom( "allieschar" );

        if ( !isdefined( var_0 ) || var_0 == "" )
        {
            if ( !isdefined( game["allies"] ) )
                var_0 = "marines";
            else
                var_0 = game["allies"];
        }

        var_1 = getmapcustom( "axischar" );

        if ( !isdefined( var_1 ) || var_1 == "" )
        {
            if ( !isdefined( game["axis"] ) )
                var_1 = "opfor";
            else
                var_1 = game["axis"];
        }

        if ( level.multiteambased )
        {
            var_2 = getmapcustom( "allieschar" );

            if ( !isdefined( var_2 ) || var_2 == "" )
                var_2 = "delta_multicam";

            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
                game[level.teamnamelist[var_3]] = var_2;
        }

        game["allies"] = var_0;
        game["axis"] = var_1;

        if ( !isdefined( game["attackers"] ) || !isdefined( game["defenders"] ) )
            thread common_scripts\utility::error( "No attackers or defenders team defined in level .gsc." );

        if ( !isdefined( game["attackers"] ) )
            game["attackers"] = "allies";

        if ( !isdefined( game["defenders"] ) )
            game["defenders"] = "axis";

        if ( !isdefined( game["state"] ) )
            game["state"] = "playing";

        if ( level.teambased )
        {
            game["strings"]["waiting_for_teams"] = &"MP_WAITING_FOR_TEAMS";
            game["strings"]["opponent_forfeiting_in"] = &"MP_OPPONENT_FORFEITING_IN";
        }
        else
        {
            game["strings"]["waiting_for_teams"] = &"MP_WAITING_FOR_MORE_PLAYERS";
            game["strings"]["opponent_forfeiting_in"] = &"MP_OPPONENT_FORFEITING_IN";
        }

        game["strings"]["press_to_spawn"] = &"PLATFORM_PRESS_TO_SPAWN";
        game["strings"]["match_starting_in"] = &"MP_MATCH_STARTING_IN";
        game["strings"]["match_resuming_in"] = &"MP_MATCH_RESUMING_IN";
        game["strings"]["waiting_for_players"] = &"MP_WAITING_FOR_PLAYERS";
        game["strings"]["spawn_tag_wait"] = &"MP_SPAWN_TAG_WAIT";
        game["strings"]["spawn_next_round"] = &"MP_SPAWN_NEXT_ROUND";
        game["strings"]["waiting_to_spawn"] = &"MP_WAITING_TO_SPAWN";
        game["strings"]["match_starting"] = &"MP_MATCH_STARTING";
        game["strings"]["change_team"] = &"MP_CHANGE_TEAM_NEXT_SPAWN";
        game["strings"]["change_team_cancel"] = &"MP_CHANGE_TEAM_CANCEL";
        game["strings"]["change_team_wait"] = &"MP_CHANGE_TEAM_WAIT";
        game["strings"]["change_class"] = &"MP_CHANGE_CLASS_NEXT_SPAWN";
        game["strings"]["change_class_cancel"] = &"MP_CHANGE_CLASS_CANCEL";
        game["strings"]["change_class_wait"] = &"MP_CHANGE_CLASS_WAIT";
        game["strings"]["last_stand"] = &"MPUI_LAST_STAND";
        game["strings"]["final_stand"] = &"MPUI_FINAL_STAND";
        game["strings"]["cowards_way"] = &"PLATFORM_COWARDS_WAY_OUT";
        game["strings"]["tie"] = &"MP_MATCH_TIE";
        game["colors"]["blue"] = ( 0.25, 0.25, 0.75 );
        game["colors"]["red"] = ( 0.75, 0.25, 0.25 );
        game["colors"]["white"] = ( 1.0, 1.0, 1.0 );
        game["colors"]["black"] = ( 0.0, 0.0, 0.0 );
        game["colors"]["grey"] = ( 0.5, 0.5, 0.5 );
        game["colors"]["green"] = ( 0.25, 0.75, 0.25 );
        game["colors"]["yellow"] = ( 0.65, 0.65, 0.0 );
        game["colors"]["orange"] = ( 1.0, 0.45, 0.0 );
        game["colors"]["cyan"] = ( 0.35, 0.7, 0.9 );
        game["strings"]["allies_name"] = maps\mp\gametypes\_teams::getteamname( "allies" );
        game["icons"]["allies"] = maps\mp\gametypes\_teams::getteamicon( "allies" );
        game["colors"]["allies"] = maps\mp\gametypes\_teams::getteamcolor( "allies" );
        game["strings"]["axis_name"] = maps\mp\gametypes\_teams::getteamname( "axis" );
        game["icons"]["axis"] = maps\mp\gametypes\_teams::getteamicon( "axis" );
        game["colors"]["axis"] = maps\mp\gametypes\_teams::getteamcolor( "axis" );

        if ( game["colors"]["allies"] == ( 0.0, 0.0, 0.0 ) )
            game["colors"]["allies"] = ( 0.5, 0.5, 0.5 );

        if ( game["colors"]["axis"] == ( 0.0, 0.0, 0.0 ) )
            game["colors"]["axis"] = ( 0.5, 0.5, 0.5 );

        [[ level.onprecachegametype ]]();
        setdvarifuninitialized( "min_wait_for_players", 5 );

        if ( level.console )
        {
            if ( !level.splitscreen )
            {
                if ( isdedicatedserver() )
                    level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "graceperiod_ds" );
                else
                    level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "graceperiod" );

                level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "matchstarttime" );
            }
        }
        else
        {
            if ( isdedicatedserver() )
                level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "playerwaittime_ds" );
            else
                level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "playerwaittime" );

            level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "matchstarttime" );
        }
    }
    else
    {
        setdvarifuninitialized( "min_wait_for_players", 3 );

        if ( level.console )
        {
            if ( !level.splitscreen )
            {
                level.prematchperiod = 5;
                level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "roundstarttime" );
            }
        }
        else
        {
            level.prematchperiod = 5;
            level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "roundstarttime" );
        }
    }

    if ( !isdefined( game["status"] ) )
        game["status"] = "normal";

    if ( game["status"] != "overtime" && game["status"] != "halftime" && game["status"] != "overtime_halftime" )
    {
        game["teamScores"]["allies"] = 0;
        game["teamScores"]["axis"] = 0;

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
                game["teamScores"][level.teamnamelist[var_3]] = 0;
        }
    }

    if ( !isdefined( game["timePassed"] ) )
        game["timePassed"] = 0;

    if ( !isdefined( game["roundsPlayed"] ) )
        game["roundsPlayed"] = 0;

    setomnvar( "ui_current_round", game["roundsPlayed"] + 1 );

    if ( !isdefined( game["roundsWon"] ) )
        game["roundsWon"] = [];

    if ( level.teambased )
    {
        if ( !isdefined( game["roundsWon"]["axis"] ) )
            game["roundsWon"]["axis"] = 0;

        if ( !isdefined( game["roundsWon"]["allies"] ) )
            game["roundsWon"]["allies"] = 0;

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
            {
                if ( !isdefined( game["roundsWon"][level.teamnamelist[var_3]] ) )
                    game["roundsWon"][level.teamnamelist[var_3]] = 0;
            }
        }
    }

    level.gameended = 0;
    level.forcedend = 0;
    level.hostforcedend = 0;
    level.hardcoremode = getdvarint( "g_hardcore" );

    if ( level.hardcoremode )
        logstring( "game mode: hardcore" );

    level.oldschool = getdvarint( "g_oldschool" );

    if ( level.oldschool )
        logstring( "game mode: oldschool" );

    level.diehardmode = getdvarint( "scr_diehard" );

    if ( !level.teambased )
        level.diehardmode = 0;

    if ( level.diehardmode )
        logstring( "game mode: diehard" );

    level.killstreakrewards = getdvarint( "scr_game_hardpoints" );

    if ( !isdefined( level.iszombiegame ) )
        level.iszombiegame = 0;

    level.usestartspawns = 1;
    level.objectivepointsmod = 1;
    level.baseplayermovescale = 1;
    level.maxallowedteamkills = 2;
    thread maps\mp\gametypes\_hodgepodge::init();
    thread maps\mp\gametypes\_persistence::init();
    thread maps\mp\gametypes\_menus::init();
    thread maps\mp\gametypes\_hud::init();
    thread maps\mp\gametypes\_serversettings::init();
    thread maps\mp\gametypes\_teams::init();
    thread maps\mp\gametypes\_weapons::init();
    thread maps\mp\gametypes\_killcam::init();
    thread maps\mp\gametypes\_shellshock::init();
    thread maps\mp\gametypes\_deathicons::init();
    thread maps\mp\gametypes\_damagefeedback::init();
    thread maps\mp\gametypes\_healthoverlay::init();
    thread maps\mp\gametypes\_spectating::init();
    thread maps\mp\gametypes\_objpoints::init();
    thread maps\mp\gametypes\_gameobjects::init();
    thread maps\mp\gametypes\_spawnlogic::init();
    thread maps\mp\gametypes\_oldschool::init();
    thread maps\mp\gametypes\_battlechatter_mp::init();
    thread maps\mp\gametypes\_music_and_dialog::init();
    thread maps\mp\_matchdata::init();
    thread maps\mp\_awards::init();
    thread maps\mp\_skill::init();
    thread maps\mp\_areas::init();
    thread maps\mp\perks\_perks::init();
    thread maps\mp\_events::init();
    thread maps\mp\gametypes\_damage::initfinalkillcam();
    thread maps\mp\_snd_common_mp::init();
    thread maps\mp\_utility::buildattachmentmaps();

    if ( level.teambased )
        thread maps\mp\gametypes\_friendicons::init();

    thread maps\mp\gametypes\_hud_message::init();
    thread maps\mp\gametypes\_divisions::init();
    thread maps\mp\gametypes\_hardpoints::init();

    foreach ( var_5 in game["strings"] )
        precachestring( var_5 );

    game["gamestarted"] = 1;

    if ( !isdefined( game["absoluteStartTime"] ) )
        game["absoluteStartTime"] = getsystemtime();

    level.maxplayercount = 0;
    level.wavedelay["allies"] = 0;
    level.wavedelay["axis"] = 0;
    level.lastwave["allies"] = 0;
    level.lastwave["axis"] = 0;
    level.waveplayerspawnindex["allies"] = 0;
    level.waveplayerspawnindex["axis"] = 0;
    level.aliveplayers["allies"] = [];
    level.aliveplayers["axis"] = [];
    level.activeplayers = [];

    if ( level.multiteambased )
    {
        for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
        {
            level._wavedelay[level.teamnamelist[var_3]] = 0;
            level._lastwave[level.teamnamelist[var_3]] = 0;
            level._waveplayerspawnindex[level.teamnamelist[var_3]] = 0;
            level._aliveplayers[level.teamnamelist[var_3]] = [];
        }
    }

    setdvar( "ui_scorelimit", 0 );
    setdvar( "ui_allow_teamchange", 1 );

    if ( maps\mp\_utility::getgametypenumlives() )
        setdvar( "g_deadChat", 0 );
    else
        setdvar( "g_deadChat", 1 );

    var_7 = getdvarfloat( "scr_" + level.gametype + "_waverespawndelay" );

    if ( var_7 > 0 )
    {
        level.wavedelay["allies"] = var_7;
        level.wavedelay["axis"] = var_7;
        level.lastwave["allies"] = 0;
        level.lastwave["axis"] = 0;

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
            {
                level._wavedelay[level.teamnamelist[var_3]] = var_7;
                level._lastwave[level.teamnamelist[var_3]] = 0;
            }
        }

        level thread wavespawntimer();
    }

    maps\mp\_utility::gameflaginit( "prematch_done", 0 );
    level.graceperiod = 3;
    level.ingraceperiod = level.graceperiod;
    maps\mp\_utility::gameflaginit( "graceperiod_done", 0 );
    level.roundenddelay = 0;
    level.halftimeroundenddelay = 1;
    level.noragdollents = getentarray( "noragdoll", "targetname" );

    if ( level.teambased )
    {
        maps\mp\gametypes\_gamescore::updateteamscore( "axis" );
        maps\mp\gametypes\_gamescore::updateteamscore( "allies" );

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
                maps\mp\gametypes\_gamescore::updateteamscore( level.teamnamelist[var_3] );
        }
    }
    else
        thread maps\mp\gametypes\_gamescore::initialdmscoreupdate();

    thread updateuiscorelimit();
    level notify( "update_scorelimit" );
    [[ level.onstartgametype ]]();
    level.scorepercentagecutoff = getdvarint( "scr_" + level.gametype + "_score_percentage_cut_off", 80 );
    level.timepercentagecutoff = getdvarint( "scr_" + level.gametype + "_time_percentage_cut_off", 80 );

    if ( !level.console && ( getdvar( "dedicated" ) == "dedicated LAN server" || getdvar( "dedicated" ) == "dedicated internet server" ) )
        thread verifydedicatedconfiguration();

    setattackingteam();
    thread startgame();
    level thread maps\mp\_utility::updatewatcheddvars();
    level thread timelimitthread();
    level thread maps\mp\gametypes\_damage::dofinalkillcam();
}
/*
autoPickupThrowingKnife()
{
    self endon("disconnect");
    level endon("game_ended");

    for(;;)
    {
        self waittill("grenade_fire", var_0, var_1);
        if (isdefined(var_0) && var_1 == "iw9_throwknife_mp")
        {
            var_0 thread watchtimeout();
            var_0 hudoutlineenableforclient(self, 1, 0);
        }
    }
}*/


autoPickupThrowingKnife(){
	self endon("death");
	self endon("disconnect");
	for(;;){
		self waittill("grenade_fire", grenade, weaponName);
        if(isdefined(grenade) && weaponName == "iw9_throwknife_mp"){
            grenade thread waitForStick();
        }
	}
}

waitForStick(){
	self waittill("missile_stuck");
	oldOrigin = undefined;
	while(self.origin != oldOrigin){
        oldOrigin = self.origin;
        wait 1;
    }
	pos = self.origin;
	model = spawn( "script_model", pos );
	model setModel("equip_iw4_throwingknife_npc");
	model.angles = self.angles;
	trigger = spawn( "trigger_radius", pos-(0,0,45), 0, 30, 50 );
	trigger thread watchTimeout(model);
	self delete();
	while(isdefined(trigger))
	{
		trigger waittill( "trigger", player );
		if(Distance(pos, player getTagOrigin("j_head")) <= 75 && player hasWeapon("iw9_throwknife_mp") && player getammocount("iw9_throwknife_mp") == 0)
		{
			player setlethalweapon("iw9_throwknife_mp");
			player maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
			player setWeaponAmmoClip("iw9_throwknife_mp", 1);
			player playLocalSound("h2_scavenger_pack_pickup");
			trigger notify("deleted");
			model delete();
			trigger delete();
		}
		wait 0.025;
	}
}

watchTimeout(model){
	self endon("deleted");
	wait 60;
	model delete();
	self delete();
}

mef_menugiveclass( var_0 )
{
    
}


mef_onstartgametype()
{
    if ( !isdefined( game["switchedsides"] ) )
        game["switchedsides"] = 0;

    if ( game["switchedsides"] )
    {
        var_0 = game["attackers"];
        var_1 = game["defenders"];
        game["attackers"] = var_1;
        game["defenders"] = var_0;
    }

    setclientnamemode( "manual_change" );
    //maps\mp\gametypes\common_bomb_gameobject::loadbombfx();
    //maps\mp\_utility::setobjectivetext( game["attackers"], &"OBJECTIVES_SD_ATTACKER" );
    //maps\mp\_utility::setobjectivetext( game["defenders"], &"OBJECTIVES_SD_DEFENDER" );
    /*
    if ( level.splitscreen )
    {
        maps\mp\_utility::setobjectivescoretext( game["attackers"], &"OBJECTIVES_SD_ATTACKER" );
        maps\mp\_utility::setobjectivescoretext( game["defenders"], &"OBJECTIVES_SD_DEFENDER" );
    }
    else
    {
        maps\mp\_utility::setobjectivescoretext( game["attackers"], &"OBJECTIVES_SD_ATTACKER_SCORE" );
        maps\mp\_utility::setobjectivescoretext( game["defenders"], &"OBJECTIVES_SD_DEFENDER_SCORE" );
    }
    */
    //maps\mp\_utility::setobjectivehinttext( game["attackers"], &"OBJECTIVES_SD_ATTACKER_HINT" );
    //maps\mp\_utility::setobjectivehinttext( game["defenders"], &"OBJECTIVES_SD_DEFENDER_HINT" );
    initspawns();
    var_2[0] = "sd";
    var_2[1] = "bombzone";
    var_2[2] = "blocker";
    maps\mp\gametypes\_gameobjects::main( var_2 );
    thread maps\mp\gametypes\common_sd_sr::updategametypedvars();
    maps\mp\_utility::setcarrierloadouts();
    thread maps\mp\gametypes\common_sd_sr::bombs();
    thread maps\mp\gametypes\_spectating::allowallyteamspectating();
}

mef_bombs()
{
    level.bombplanted = 0;
    level.bombdefused = 0;
    level.bombexploded = 0;
    var_0 = getent( "sd_bomb_pickup_trig", "targetname" );

    if ( !isdefined( var_0 ) )
    {
        common_scripts\utility::error( "No sd_bomb_pickup_trig trigger found in map." );
        return;
    }

    var_1 = maps\mp\gametypes\common_bomb_gameobject::getcarrybombvisuals( "sd_bomb" );

    if ( !isdefined( var_1 ) )
    {
        common_scripts\utility::error( "No sd_bomb script_model found in map." );
        return;
    }

    if ( !level.multibomb )
    {
        //level.sdbomb = maps\mp\gametypes\common_bomb_gameobject::createbombcarryobject( game["attackers"], "friendly", var_0, var_1 );
        //thread maps\mp\_utility::streamcarrierweaponstoplayers( level.sdbomb, [ game["attackers"] ], ::shouldstreamcarrierclasstoplayer );

        //if ( game["attackers"] == "allies" )
        //    maps\mp\_utility::setmlgicons( level.sdbomb, "waypoint_bomb_green" );
        //else
        //    maps\mp\_utility::setmlgicons( level.sdbomb, "waypoint_bomb_red" );

        //level.sdbomb.onpickup = ::onpickup;
        //level.sdbomb.ondrop = ::ondrop;
    }
    else
    {
        var_0 delete();
        var_1[0] delete();
    }

    level.bombzones = [];
    var_2 = getentarray( "bombzone", "targetname" );
    var_3 = getentarray( "bombzone_augmented", "targetname" );

    if ( maps\mp\_utility::isaugmentedgamemode() )
    {
        for ( var_4 = 0; var_4 < var_3.size; var_4++ )
        {
            var_5 = var_3[var_4].script_label;

            for ( var_6 = 0; var_6 < var_2.size; var_6++ )
            {
                if ( var_2[var_6].script_label == var_5 )
                {
                    removebombzone( var_2[var_6] );
                    break;
                }
            }
        }
    }
    else
    {
        for ( var_7 = 0; var_7 < var_3.size; var_7++ )
            removebombzone( var_3[var_7] );
    }

    var_2 = common_scripts\utility::array_combine( var_2, var_3 );

    for ( var_7 = 0; var_7 < var_2.size; var_7++ )
    {
        var_0 = var_2[var_7];
        var_1 = getentarray( var_2[var_7].target, "targetname" );
        var_8 = undefined;

        if ( !level.multibomb )
            var_8 = level.sdbomb;

        //var_9 = maps\mp\gametypes\common_bomb_gameobject::createbombzoneobject( game["defenders"], "enemy", "any", var_0, var_8, 1 );
        var_9 = undefined;
        maps\mp\_utility::setmlgicons( var_9, "waypoint_esports_snd_target" + var_9.label + "_white" );
        var_9.onbeginuse = ::onbeginuse;
        var_9.onenduse = ::onenduse;
        var_9.onuse = ::onuseplantobject;
        var_9.oncantuse = ::oncantuse;
        level.bombzones[level.bombzones.size] = var_9;
        var_9.bombdefusetrig = getent( var_1[0].target, "targetname" );
        var_9.bombdefusetrig.origin += ( 0.0, 0.0, -10000.0 );
        var_9.bombdefusetrig.label = var_9.label;
        var_9.bombdefusetrig usetriggertouchcheckstance( 1 );
    }

    for ( var_7 = 0; var_7 < level.bombzones.size; var_7++ )
    {
        var_10 = [];

        for ( var_11 = 0; var_11 < level.bombzones.size; var_11++ )
        {
            if ( var_11 != var_7 )
                var_10[var_10.size] = level.bombzones[var_11];
        }

        level.bombzones[var_7].otherbombzones = var_10;
    }

    setomnvar( "ui_mlg_game_mode_status_1", 0 );
}